@extends('user')
@section('content')
    @include('partials.breadcrumb')
    <div class="row my-5">
        <div class="col-md-12">
            <div class="panel panel-inverse" style="padding:123px 0px;">
                <div class="panel-body">
                    <div class="d-flex justify-content-center">
                        <div  class="col-md-4 col-md-offset-4 text-center">
                            <form class="contact-form" method="POST" action="{{route('deposit.confirm')}}">
                                {{csrf_field()}}


                                <div class="panel">
                                    <div class="panel-body">
                                        <ul class="list-group text-center">
                                            <li class="list-group-item">
                                                <img src="{{asset('assets/images/gateway')}}/{{$data->gateway_id}}.jpg"
                                                     style="max-width:100px; max-height:100px; margin:0 auto;"/>
                                            </li>
                                            <li class="list-group-item">@lang('Amount') : {{$data->amount}} <strong>{{__($basic->currency)}}</strong></li>
                                            <li class="list-group-item">@lang('Charge') : <strong>{{$data->charge}} </strong>{{ __($basic->currency) }}</li>
                                            <li class="list-group-item">@lang('Payable') : <strong>{{$data->charge + $data->amount}} </strong>{{ __($basic->currency) }}</li>
                                            <li class="list-group-item">In USD: <strong>${{$data->usd}}</strong></li>
                                        </ul>
                                    </div>
                                    <br>
                                    <div class="panel-footer">
                                        <button id="btn-confirm" type="submit" class="btn btn-primary btn-block btn-lg custom-button">@lang('Pay Now')</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@stop
@section('script')
    @if($data->gateway_id == 107)
        <form action="{{ route('ipn.paystack') }}" method="POST">
            @csrf
            <script
                src="//js.paystack.co/v1/inline.js"
                data-key="{{ $data->gateway->val1 }}"
                data-email="{{ $data->user->email }}"
                data-amount="{{ round($data->usd/$data->gateway->val7, 2)*100 }}"
                data-currency="NGN"
                data-ref="{{ $data->trx }}"
                data-custom-button="btn-confirm">
            </script>
        </form>
    @elseif($data->gateway_id == 108)
        <script src="//voguepay.com/js/voguepay.js"></script>
        <script>
            closedFunction = function () {

            }
            successFunction = function (transaction_id) {
                window.location.href = '{{ url('user/vogue') }}/' + transaction_id + '/success';
            }
            failedFunction = function (transaction_id) {
                window.location.href = '{{ url('user/vogue') }}/' + transaction_id + '/error';
            }

            function pay(item, price) {
                //Initiate voguepay inline payment
                Voguepay.init({
                    v_merchant_id: "{{ $data->gateway->val1 }}",
                    total: price,
                    notify_url: "{{ route('ipn.voguepay') }}",
                    cur: 'USD',
                    merchant_ref: "{{ $data->trx }}",
                    memo: 'Buy ICO',
                    recurrent: true,
                    frequency: 10,
                    developer_code: '5af93ca2913fd',
                    store_id: "{{ $data->user_id }}",
                    custom: "{{ $data->trx }}",

                    closed: closedFunction,
                    success: successFunction,
                    failed: failedFunction
                });
            }

            $(document).ready(function () {
                $(document).on('click', '#btn-confirm', function (e) {
                    e.preventDefault();
                    pay('Buy', {{ $data->usd }});
                });
            })
        </script>

    @endif
@endsection
